<?php
namespace Elementor;

class esio_show_testimonials02_slider_widget extends Widget_Base {

  public function get_name() {
    return 'testimonals02';
  }

  public function get_title() {
    return 'Esio - Testimonials 02';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'number',
        [
          'label' => __( 'Number', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => '3',
        ]
    );

    $this->add_control(
      'testimonial_image_background_color',
        [
          'label' => __( 'Image background color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
        ]
    );

    $this->add_control(
      'testimonial_text_background_color',
        [
          'label' => __( 'Text background color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
        ]
    );

    $this->add_control(
      'testimonial_text_color',
        [
          'label' => __( 'Text color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
        ]
    );

    $this->add_control(
      'testimonial_position_color',
        [
          'label' => __( 'Position text color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
        ]
    );

    $this->end_controls_section();
  }

  protected function render() {

    global $ibid_redux;
    $settings                              = $this->get_settings_for_display();
    $number                                = $settings['number'];
    $testimonial_image_background_color    = $settings['testimonial_image_background_color'];
    $testimonial_text_background_color     = $settings['testimonial_text_background_color'];
    $testimonial_text_color                = $settings['testimonial_text_color'];
    $testimonial_position_color            = $settings['testimonial_position_color'];

    $html = '';
    $html .= '<div class="">';
      $html .= '<div class="testimonials02-container wow">';
      $args_testimonials = array(
        'posts_per_page'   => $number,
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'post_type'        => 'testimonial',
        'post_status'      => 'publish' 
      ); 

        $testimonials = get_posts($args_testimonials);
          foreach ($testimonials as $testimonial) {
            #metaboxes
            $metabox_job_position = get_post_meta( $testimonial->ID, 'job-position', true );
            $metabox_company = get_post_meta( $testimonial->ID, 'company', true );
            // $metabox_testimonial_bg = get_post_meta( $testimonial->ID, 'smartowl_testimonial_bg_color', true );
            $testimonial_id = $testimonial->ID;
            $content_post   = get_post($testimonial_id);
            $content        = $content_post->post_content;
            $content        = apply_filters('the_content', $content);
            $content        = str_replace(']]>', ']]&gt;', $content);
            #thumbnail
            $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $testimonial->ID ),'eaglewp_testimonials02_250x530' );
            $html.='<div class="row">';
              $html.='<div class="item vc_col-md-12 relative">';
                $html.='<div class="testimonials_all_holder">';
                  $html .= '<div class="vc_col-md-3 testimonial02-img-holder"">';
                    $html .= '<div class="row">';
                      if($thumbnail_src) { 
                        $html .= '<img class="testimonial02-img" src="'. $thumbnail_src[0] . '" alt="'. $testimonial->post_title .'" />';
                      }else{ 
                        $html .= '<img class="testimonial02-img" src="http://placehold.it/250x300" alt="'. $testimonial->post_title .'" />'; 
                      }
                    $html .= '</div>';
                  $html .= '</div>';
                  $html .= '<div class="vc_col-md-9 testimonial02-text-holder">';
                    $html .= '<div class="testimonial02-content">';
                      $html .= '<div class="testimonial02_text">';
                          $html .= '<div class="testimonial02_text_content">'.$content.'</div>';
                            $html .= '<h4 class="testimonial02_title">'.$testimonial->post_title .'</h4>';
                            $html .= '<h4 class="testimonial02_position">'.esc_attr($metabox_job_position).'</h4>';
                          $html .= '</div>';
                        $html .= '</div>';
                      $html .= '</div>';
                    $html .= '</div>';
                  $html .= '</div>';
                $html .= '</div>';
              }
            $html .= '</div>';
          $html .= '</div>

    <style type="text/css" scoped>
      .testimonials_all_holder {
          background-color: '.esc_attr($testimonial_text_background_color).';
      }
      .testimonials02-container .testimonial02-img-holder {
          background-color: '.esc_attr($testimonial_image_background_color).';
      }
      .testimonials02-container .testimonial02-text-holder {
          background-color: '.esc_attr($testimonial_text_background_color).';
      }
      .testimonials02-container .testimonial02-text-holder .testimonial02_text_content p {
          color: '.esc_attr($testimonial_text_color).';
      }
      .testimonials02-container .testimonial02-text-holder .testimonial02_title {
          color: '.esc_attr($testimonial_text_color).';
      }
      .testimonials02-container .testimonial02-text-holder .testimonial02_position{
          color: '.esc_attr($testimonial_position_color).';
      }
      .testimonials02-container.owl-theme .owl-controls .owl-buttons div {
          color: '.esc_attr($testimonial_position_color).';
      }
    </style>';

  echo $html;

  }
  protected function _content_template() {

  }
}