<?php
namespace Elementor;

class esio_show_portfolio_single_info_widget extends Widget_Base {

  public function get_name() {
    return 'portfolio-grid';
  }

  public function get_title() {
    return 'Esio - Single Portfolio Info';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {

    $this->end_controls_section();
  }
  protected function render() {
    global $wpdb;

    global $ibid_redux;
    $settings         = $this->get_settings_for_display();

    $html = '';
    $portfolio_client = get_post_meta( get_the_id(), 'portfolio_client', true );
    $portfolio_tags = get_post_meta( get_the_id(), 'portfolio_tags', true );
    $portfolio_service = get_post_meta( get_the_id(), 'portfolio_service', true );
    $portfolio_link = get_post_meta( get_the_id(), 'portfolio_link', true );
    $terms = wp_get_post_terms( get_the_id(),  'mt-portfolio-category2'); 

    $mt_portfolio_category = '';
    $mt_portfolio_link = '';
    $mt_portfolio_category_link = '';
    foreach ( $terms as $term ) :
      if( $term->parent == 0 ) :
        $mt_portfolio_category = $term->name . ' ';
        $mt_portfolio_link = get_term_link( $term->slug, 'mt-portfolio-category2' );
        $mt_portfolio_category_link .= '<a href="'.esc_url($mt_portfolio_link).'">'. $mt_portfolio_category .'</a>';
      endif;
    endforeach; 
                
                $html.='
	                	<div class="mt-single-portofolio-info">        	
		                	<div class="mt-single-portofolio-info-holder">';
                        if($mt_portfolio_category_link) {
                          $html.='<div class="single-portfolio-info">
                              <p><strong>'.esc_html__('Category:','modeltheme').'</strong> '.$mt_portfolio_category_link.'</p>
    		                  </div>';
                        }

                        if($portfolio_client) {
                          $html.='<div class="single-portfolio-info">
                              <p><strong>'.esc_html__('Client:','modeltheme').'</strong> '.$portfolio_client.'</p>
                          </div>';
                        }

                        if($portfolio_tags) {
                          $html.='<div class="single-portfolio-info">
                              <p><strong>'.esc_html__('Tags:','modeltheme').'</strong> '.$portfolio_tags.'</p>
                          </div>';
                        }

                        if($portfolio_service) {
                          $html.='<div class="single-portfolio-info">
                              <p><strong>'.esc_html__('Services:','modeltheme').'</strong> '.$portfolio_service.'</p>
                          </div>';
                        }

                        if($portfolio_service) {
                          $html.='<div class="single-portfolio-info">
                            <p><strong>'.esc_html__('Link:','modeltheme').'</strong><a href="'.esc_url($portfolio_link).'"> '.$portfolio_link.'</a></p>
                          </div>';
                        }
                        $html.='<div class="single-portfolio-info">
                            <p class="share-portfolio"><strong>'.esc_html__('Share:','modeltheme').'</strong></p>
                            <ul class="social-share">
                              <li><a class="fa fa-facebook" target="_blank" href="https://www.facebook.com/sharer.php?u='.get_permalink().'"></a></li>
                              <li><a class="fa fa-twitter" target="_blank" href="https://twitter.com/home/?status='.get_permalink().'"></a></li>
                              <li><a class="fa fa-linkedin" target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&amp;url='.get_permalink().'"></a></li>
                            </ul>
                        </div>
		                  </div>
                    </div>';
    echo $html;
}
protected function _content_template() {

  }
}