<?php
namespace Elementor;

class esio_show_portfolio_grid_widget extends Widget_Base {

  public function get_name() {
    return 'portfolio-grid01';
  }

  public function get_title() {
    return 'Esio - Portfolio Grid';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'number',
        [
          'label' => __( 'Number', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => '3',
        ]
    );

   $post_category_tax = get_terms('mt-portfolio-category2');
    $post_category = array();
    if ($post_category_tax) {
      foreach ( $post_category_tax as $term ) {
         $post_category[$term->slug] = $term->name;
      }
      $post_category['all_categories'] = 'All categories';
    }

    $this->add_control(
      'category',
      [
        'label' => __( 'Select Portfolio Category', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => 'all_categories',
        'options' => $post_category,
      ]
    );

    $this->end_controls_section();
  }
  protected function render() {
    global $wpdb;

    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $category         = $settings['category'];
    $number           = $settings['number'];

    $html = '';
        $html .= '<div class="modeltheme-portofolio-shortcode">';

        $tax_query[ ] = array();
        if( $category != 'all_categories' ) {
          $tax_query  = array(
            array(
              'taxonomy' => 'mt-portfolio-category2',
              'field'    => 'slug',
              'terms'    => $category,
            )
          );
          $args = array(
            'posts_per_page'   => $number,
            'orderby'          => 'post_date',
            'order'            => 'DESC',
            'post_type'        => 'mt_portfolio',
            'tax_query' => $tax_query,
            'post_status'      => 'publish' 
          ); 
        } elseif( $category == 'all_categories' ) {
          $args = array(
            'posts_per_page'   => $number,
            'orderby'          => 'post_date',
            'order'            => 'DESC',
            'post_type'        => 'mt_portfolio',
            'post_status'      => 'publish' 
          ); 
        }
        $themes = get_posts($args);
            foreach ($themes as $theme) {
                #thumbnail
                $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $theme->ID ), 'esio_portfolios_600x600' );

                $custom_link  = get_post_meta( $theme->ID, 'mt_portfolio_custom_link', true );

                 $terms = wp_get_post_terms(  $theme->ID,  'mt-portfolio-category2'); 

                    $mt_portfolio_category = '';
                    $mt_portfolio_link = '';
                    $mt_portfolio_category_link = '';
                    foreach ( $terms as $term ) :
                       if( $term->parent == 0 ) :
                         $mt_portfolio_category = $term->name . ' ';
                         $mt_portfolio_link = get_term_link( $term->slug, 'mt-portfolio-category2' );
                         $mt_portfolio_category_link .= '<a href="'.esc_url($mt_portfolio_link).'">'. $mt_portfolio_category .'</a>';
                       endif;
                    endforeach; 

                $portfolio_link_button = '';
                if(!empty($custom_link)) {
                    $portfolio_link_button = $custom_link;
                } else {
                    $portfolio_link_button = get_permalink($theme->ID);
                }
                
                $html.='
                	<div class="col-md-4 col-sm-6 col-xs-12 relative">
	                	<div class="modeltheme-portofolio-grid">        	
		                	<div class="modeltheme-portofolio-img-holder pull-left">
                        <div class="portofolio-profile-content">
	                        <div class="portofolio-profile-img">
	                        	<img src="'.esc_url($thumbnail_src[0]).'"><a href="'.esc_url($portfolio_link_button).'"></>
                            <div class="thumbnail-overlay absolute">
                              <i class="fa fa-plus absolute"></i>
                            </div>
	                        </div>
                          
                          <div class="post-details ">
  	                        <div class="portofolio-name-position">
  		                        <h6 class="name-test"><a href="'.esc_url($portfolio_link_button).'">'. esc_attr($theme->post_title) .'</a></h6>
                              <h6 class="post-category">'.$mt_portfolio_category_link.'</h6>
  		                    </div>
                        </div>
		                </div>
                      </div>
		                </div>
	                </div>';
            }
    $html .= '</div>';
    echo $html;
}
protected function _content_template() {

  }
}