<?php
namespace Elementor;

class esio_show_mailchimp_subscribe_form extends Widget_Base {

  public function get_name() {
    return 'mailchimp-subscribe-form';
  }

  public function get_title() {
    return 'Esio - Mailchimp Subscribe Form';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'placeholder',
        [
          'label' => __( 'Placeholder', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => 'Email...',
        ]
    );

    $this->add_control(
      'button-text',
        [
          'label' => __( 'Button Text', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => 'Submit',
        ]
    );

    $this->end_controls_section();
  }

  protected function render() {

    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $placeholder         = $settings['placeholder'];
    $button_text         = $settings['button-text'];

    if (isset($_POST['mailchimp_email'])) {

        #Global variable - REDUX FRAMEWORK

        global $esio_redux;

        $apiKey         = $esio_redux['mt_mailchimp_apikey'];

        $listId         = $esio_redux['mt_mailchimp_listid'];

        $double_optin   = false;

        $send_welcome   = false;

        $email_type     = 'html';

        $email          = $_POST['mailchimp_email'];

        //replace us2 with your actual datacenter

        $submit_url = "http://" . $esio_redux['mt_mailchimp_data_center'] . ".api.mailchimp.com/1.3/?method=listSubscribe";

        $data = array(

            'email_address' => $email,

            'apikey'        => $apiKey,

            'id'            => $listId,

            'double_optin'  => $double_optin,

            'send_welcome'  => $send_welcome,

            'email_type'    => $email_type

        );

        $payload = json_encode($data);

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $submit_url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_POST, true);

        curl_setopt($ch, CURLOPT_POSTFIELDS, urlencode($payload));

        $result = curl_exec($ch);

        curl_close ($ch);

        $data = json_decode($result);

        if ($data->error){ ?>

            <p class="mcsf-success-message"><?php echo esc_html__("Got it, you've been added to our email list.", "modeltheme"); ?></p>

       <?php } else { ?>

            <p class="mcsf-success-message"><?php echo esc_html__("Got it, you've been added to our email list.", "modeltheme"); ?></p>

       <?php }

    }

    $html = '';

    $html .= '<div class="mc_embed_signup ">';

        $html .= '<div class="email">';

            $html .= '<form class="subscribe" method="POST">';

                $html .= '<input type="text" placeholder="'.$placeholder.'" name="mailchimp_email" class="emaddress" data-validate="validate(required, email)"/>';

                $html .= '<button class="btn-warning rippler rippler-default" name="submit_mailchimp" type="submit">'.$button_text.'</button>';

                $html .= '<span class="result section-description"></span>';

            $html .= '</form>';

        $html .= '</div>';

    $html .= '</div>';

    echo $html;

}

protected function _content_template() {

  }
}